/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.base.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class PathUtils {
    protected static Logger logger = Logger.getLogger("filenet.vw.base");
    private static String m_className = "PathUtils";
    private static String pathSeparator = System.getProperty("path.separator");
    private String myPath = System.getProperty("java.class.path");
    private static final long serialVersionUID = 464L;

    public static String _get_FILE_DATE() {
        return "$Date:   16 Oct 2006 11:45:26  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   lnguyen  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.7  $";
    }

    public PathUtils() {
    }

    public PathUtils(String path) {
        this.addPath(path);
    }

    public void addPath(String path) {
        this.myPath = path + pathSeparator + this.myPath;
    }

    private File[] parsePath(boolean wantDirectoriesOnly) {
        if (this.myPath == null) {
            return null;
        }
        String m_method = "parsePath";
        if (logger.isFinest()) {
            logger.finest(m_className, "parsePath", "Examining path=" + this.myPath);
        }
        Vector<Object> v = new Vector<Object>(1);
        StringTokenizer stmp = new StringTokenizer(this.myPath, pathSeparator);
        String token = this.myPath;
        if (stmp.countTokens() > 0) {
            while (stmp.hasMoreTokens()) {
                token = stmp.nextToken();
                if (token == null || token.length() <= 0) continue;
                File aFile = new File(token);
                if (wantDirectoriesOnly && !aFile.isDirectory()) {
                    aFile = aFile.getParentFile();
                }
                if (v.contains(aFile)) continue;
                v.add(aFile);
            }
        } else {
            v.add(this.myPath);
        }
        if (v.size() == 0) {
            return null;
        }
        return v.toArray(new File[0]);
    }

    public InputStream getResourceAsStreamFromDirectory(String name) throws FileNotFoundException {
        String m_method = "getResourceAsStreamFromDirectory(" + name + ")";
        File[] paths = this.parsePath(true);
        int nItems = 0;
        if (paths != null) {
            nItems = paths.length;
        }
        for (int i = 0; i < nItems; ++i) {
            String pathName;
            File aFile;
            if (paths[i] == null || !(aFile = new File(pathName = paths[i].getAbsolutePath() + File.separator + name)).exists()) continue;
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Bingo! Found at " + aFile.getAbsolutePath());
            }
            return new FileInputStream(aFile);
        }
        FileNotFoundException ex = new FileNotFoundException(name);
        logger.throwing(m_className, m_method, ex);
        throw ex;
    }

    public String getResourceLocation(String name) throws FileNotFoundException {
        String m_method = "getResourceLocation(" + name + ")";
        File[] paths = this.parsePath(false);
        int nItems = 0;
        if (paths != null) {
            nItems = paths.length;
        }
        for (int i = 0; i < nItems; ++i) {
            String pathName;
            if (paths[i].isDirectory()) {
                pathName = paths[i].getAbsolutePath() + File.separator + name;
                File aFile = new File(pathName);
                if (!aFile.exists()) continue;
                String s = aFile.getAbsolutePath();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Bingo! Found at " + s);
                }
                return s;
            }
            try {
                pathName = paths[i].getAbsolutePath();
                JarFile jFile = new JarFile(paths[i]);
                ZipEntry z = jFile.getEntry(name);
                if (z == null) continue;
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Bingo! Found in JAR at " + pathName + "," + z.getName());
                }
                return pathName;
            }
            catch (Exception e) {
                logger.throwing(m_className, m_method, e);
            }
        }
        FileNotFoundException ex = new FileNotFoundException(name);
        logger.throwing(m_className, m_method, ex);
        throw ex;
    }

    public InputStream getResourceAsStream(String name) throws FileNotFoundException {
        String m_method = "getResourceAsStream(" + name + ")";
        File[] paths = this.parsePath(false);
        int nItems = 0;
        if (paths != null) {
            nItems = paths.length;
        }
        for (int i = 0; i < nItems; ++i) {
            String pathName;
            if (paths[i].isDirectory()) {
                pathName = paths[i].getAbsolutePath() + File.separator + name;
                File aFile = new File(pathName);
                if (!aFile.exists()) continue;
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Bingo! Found at " + aFile.getAbsolutePath());
                }
                return new FileInputStream(aFile);
            }
            try {
                pathName = paths[i].getAbsolutePath();
                JarFile jFile = new JarFile(paths[i]);
                InputStream res = jFile.getInputStream(jFile.getEntry(name));
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Bingo! Found in JAR at " + pathName);
                }
                return res;
            }
            catch (Exception e) {
                logger.throwing(m_className, m_method, e);
            }
        }
        FileNotFoundException ex = new FileNotFoundException(name);
        logger.throwing(m_className, m_method, ex);
        throw ex;
    }

    public String toString() {
        return this.myPath;
    }

    public static void main(String[] args) {
        int nArgs;
        int n = nArgs = args == null ? 0 : args.length;
        if (nArgs == 0) {
            System.out.println("Use this class to retrieve the file location of a class in a classpath.");
            System.exit(0);
        }
        for (int i = 0; i < nArgs; ++i) {
            String className = args[i];
            String classLocation = null;
            String classLoaderInfo = null;
            String error = null;
            try {
                ProtectionDomain pd = Class.forName(className).getProtectionDomain();
                if (pd != null) {
                    CodeSource cs = pd.getCodeSource();
                    if (cs != null) {
                        classLocation = cs.toString();
                    } else {
                        error = "No CodeSource found!";
                    }
                    classLoaderInfo = Class.forName(className).getClassLoader().toString();
                } else {
                    error = "No ProtectionDomain found!";
                }
                if (error != null) {
                    System.err.println(className + "=ERROR!=" + error);
                    continue;
                }
                System.out.println(className + "=" + classLocation + "," + classLoaderInfo);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

